

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.Font;
import java.awt.geom.Ellipse2D;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.BufferStrategy;
import java.awt.Point;
import java.util.Random;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.Transparency;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class CircuitConductor extends Canvas implements KeyListener
{

      private BufferStrategy strategy;
      private long timePassed;
      private MediaManager mediaManager;
      private ArrayList BadSparks;
      private Player player;
      private ArrayList Bulbs;
      private int bulbsLit;
      private int bulbsTotal;
      private TileMap maze;
      private boolean gameEnded = false;

      public CircuitConductor()
      {
		  mediaManager = new MediaManager();
          JFrame frame = new JFrame("CircuitConductor");
          JPanel panel = (JPanel)frame.getContentPane();
          setBounds(0,0,725,725);
          panel.setPreferredSize(new Dimension(725,725));
          panel.setLayout(null);
          panel.add(this);

          frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
          frame.setTitle("CircuitConductor");
          frame.setFocusTraversalKeysEnabled(false);

          frame.setBounds(0,0,725,725);
          frame.setVisible(true);
          frame.setResizable(false);
          createBufferStrategy(2);
          strategy = getBufferStrategy();
          requestFocus();
          addKeyListener(this);

          setIgnoreRepaint(true);
      }

      public void initialize()
      {
		  maze = new TileMap(this);

		  Bulbs = new ArrayList();
		  for (int i = 0; i < 6; i++)
		  {
			  Bulb b = new Bulb(this);
		      b.setX(445.5);
	          b.setY(48 + (i * 2) * 50);
		      Bulbs.add(b);
          }
          setBulbsTotal(Bulbs.size());
          setBulbsLit(0);

          BadSparks = new ArrayList();
          for (int i = 0; i < 6; i++)
          {
			  BadSpark bs = new BadSpark(this, maze);
              bs.setX(495);
              bs.setY(63 + (i * 100));
              bs.setVx(4);
              BadSparks.add(bs);
          }


          BadSpark v1 = new BadSpark(this, maze);
          v1.setX(298.0);
		  v1.setY(63.0);
		  v1.setVy(4);
          BadSparks.add(v1);

          BadSpark v2 = new BadSpark(this, maze);
		  v2.setX(598.0);
		  v2.setY(563.0);
		  v2.setVy(4);
          BadSparks.add(v2);

          player = new Player(this, maze);
		  player.setX(-4.5);
	      player.setY(350.5);

	      Random random = new Random();

          if(random.nextInt() % 2 == 0)
	         mediaManager.playMusic("Title0.mid");
	      else
	         mediaManager.playMusic("Level.mid");
      }

      public void addSparkObject(GameObject inGameObject)
      {
		  BadSparks.add(inGameObject);
	  }

	  public Player getPlayer()
	  {
		  return player;
	  }

	  public int getBulbsTotal()
	  {
		  return bulbsTotal;
	  }

	  public int getBulbsLit()
	  {
		  return bulbsLit;
	  }

	  public void setBulbsTotal(int inBulbsTotal)
	  {
		  bulbsTotal = inBulbsTotal;
	  }

	  public void setBulbsLit(int inBulbsLit)
	  {
		  bulbsLit = inBulbsLit;
	  }

      public void update()
      {
		  int i = 0;
		  for (i = 0; i < Bulbs.size(); i++)
		  {
			  Bulb b = (Bulb)Bulbs.get(i);
			  b.move();
          }

          i = 0;
          while(i < BadSparks.size())
          {
			  GameObject bs = (GameObject)BadSparks.get(i);
              if (bs.toBeKilled())
              {
				  BadSparks.remove(i);
	          } else
	          {
				  bs.move();
			      i++;
		      }
         }

         if(player.toBeKilled() && player.getLivesLeft() > 0)
         {
			 int lives = player.getLivesLeft();
			 int bulbs = player.getBulbGaugeCount();
			 player = new Player(this, maze);
		     player.setX(-4.5);
	         player.setY(350.5);
	         player.setLivesLeft(lives);
	         player.setBulbGaugeCount(bulbs);
		 } else if (player.getLivesLeft() <= 0)
		 {
		     this.gameOver();
		 } else {
			 player.move();
		 }
	  }

      public void handleCollisions()
      {
		  player.setBounds((int)(player.getX() + 14),(int)(player.getY() + 14),30,30);
          Rectangle playerBounds = player.getBounds();
          for (int i = 0; i < BadSparks.size(); i++)
          {
			  BadSpark bs = (BadSpark)BadSparks.get(i);
              bs.setBounds((int)(bs.getX() + 12),(int)(bs.getY() + 12),30,30);
              Rectangle r1 = bs.getBounds();
              if (r1.intersects(playerBounds))
              {
				  player.collision(bs);
                  bs.collision(player);
              }

              for (int j = 0; j < Bulbs.size(); j++)
              {
				  Bulb b = (Bulb)Bulbs.get(j);
                  b.setBounds((int)(b.getX() + 30),(int)(b.getY() + 30),25,25);
                  Rectangle bulbBounds = b.getBounds();
                  if (playerBounds.intersects(bulbBounds))
                  {
					  if(b.notLit())
					  {
						  b.collision(player);
                          setBulbsLit(getBulbsLit() + 1);
                          player.setBulbGaugeCount(player.getBulbGaugeCount() + 1);
                      }
                 }
             }

          }
      }

      public void paintLivesRemaining(Graphics2D g)
      {
		  for (int i = 0; i < player.getLivesLeft() - 1;i++)
		  {
			  BufferedImage pl = mediaManager.getBitmap("sparkGlow7.png");
			  g.drawImage( pl ,20+i*pl.getWidth(),20 - 5,this);
          }
      }

      public void paintBulbGauge(Graphics2D g)
      {
		  int bulbGaugeCount = player.getBulbGaugeCount();
          for (int i = 0; i < 10;i++)
          {
			  if(bulbGaugeCount > 0)
		      {
				  g.setColor(Color.yellow);
		          g.fillRect(i* 12 + (725 / 2) + 50,20,7,25);
		          bulbGaugeCount--;
		      }

		      g.setColor(Color.blue);
              g.drawRect(i* 12 + (725 / 2) + 50,20,7,25);
          }
          g.setFont( new Font("Haettenschweiler",Font.PLAIN,16));
          g.setColor(Color.white);
// change
          g.drawString("  SD   F",(725 / 2) + 65,20 - 5);
      }

      public void paintBulbTally(Graphics2D g)
      {
		  BufferedImage lb = mediaManager.getBitmap("lbOn.gif");
		  g.drawImage( lb ,725-40,20,this);
          g.setFont( new Font("Haettenschweiler",Font.PLAIN,16));
		  g.setColor(Color.white);
          g.drawString(getBulbsLit() + "/" +getBulbsTotal(),725-60,20 + 25);
      }

      public void paintHUD(Graphics2D g)
      {
		  paintLivesRemaining(g);
          paintBulbGauge(g);
          paintBulbTally(g);
      }

      public void paintGame()
      {
        Graphics2D g = (Graphics2D)strategy.getDrawGraphics();

		g.setColor(Color.black);
		g.fillRect(0,0,725,725);
		g.drawRect(0,0,725,725);


        g.setColor(Color.black);
		g.fillRect(0,0,getWidth(),65);

		maze.paint(g);


        for (int i = 0; i < Bulbs.size(); i++)
        {
		  Bulb b = (Bulb)Bulbs.get(i);
		  b.paint(g);
	    }


        for (int i = 0; i < BadSparks.size(); i++)
        {
          BadSpark bs = (BadSpark)BadSparks.get(i);
          bs.paint(g);
        }

        if(!player.toBeKilled())
        {
          player.paint(g);
	    }

        paintHUD(g);
        strategy.show();
      }

      public MediaManager getMediaManager()
      {
        return mediaManager;
      }

      public void keyPressed(KeyEvent e)
      {
		  player.keyPressed(e);
	  }

	  public void keyReleased(KeyEvent e)
	  {
		  player.keyReleased(e);
	  }

	  public void keyTyped(KeyEvent e)
	  {

	  }

	  public void gameOver()
	  {
		  gameEnded = true;
	  }

      public void paintGameOver()
      {
		  Graphics2D g = (Graphics2D)strategy.getDrawGraphics();
          g.setColor(Color.white);
          g.setFont(new Font("Haettenschweiler",Font.PLAIN,40));
          g.drawString("GAME OVER",725/2-50,725/2);
          strategy.show();
      }


      public void game()
      {
        timePassed = 1000;
        initialize();
        while (isVisible() && !gameEnded)
        {
			long timer = System.currentTimeMillis();
            update();
            handleCollisions();
            paintGame();
            timePassed = System.currentTimeMillis() - timer;
            do {
				Thread.yield();
		    }while(System.currentTimeMillis() - timer < 17);
       }
       paintGameOver();
     }

     public static void main(String[] args)
     {
       CircuitConductor cc = new CircuitConductor();
       cc.game();
     }
}